#version 330
#extension GL_EXT_gpu_shader4 : enable
// Fractal SeptagonMod01.fsh  by   mathmasterzach

//https://www.shadertoy.com/view/wllXWB
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//Based on http://paulbourke.net/fractals/septagon/

//uncomment to modify the ϕ value with your mouse
//#define MOUSE_CONTROL

float MAX_STEPS=512.;
float PI=acos(-1.);
float AA=1.;

#define vecMul(a,b) vec2(a.x*b.x-a.y*b.y,a.x*b.y+a.y*b.x)
#define vecDiv(a,b) vec2(a.x*b.x+a.y*b.y,a.y*b.x-a.x*b.y)/(b.x*b.x+b.y*b.y)

mat2 matRot(float a){
	float c=cos(a),
          s=sin(a);
    return mat2(c,s,s,-c);
}

vec3 samplePoint(vec2 c,float maxIters){
    float i;
    for(i=0.;i<maxIters;i++){
        vec2 c2 = vecMul(c ,c );
        vec2 c3 = vecMul(c2,c );
        vec2 c6 = vecMul(c3,c3);
        vec2 c7 = vecMul(c6,c );
        #ifdef MOUSE_CONTROL
        	c7+=2.*iMouse.xy/iResolution.xy-1.;
        #else
        	c7.x -=.7/5.;
        #endif
        c = vecDiv(c7,c );
        if(length(c)>2.){
            break;
        }
    }
    float ic=(5.*i/maxIters);
    return vec3(cos(1.-ic)+1.,cos(2.-ic)+1.,cos(3.-ic)+1.)/2.;
    //uncomment this and comment the line above to see a warped grid overlay
    //c=fract(c/10.)-.5;
    //float lg=2.*max(abs(c.x),abs(c.y));
    //return lg*vec3(cos(1.-ic)+1.,cos(2.-ic)+1.,cos(3.-ic)+1.)/2.;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 c = 2.*gl_FragCoord.xy/iResolution.xy-1.;
    c.x*=iResolution.x/iResolution.y;
    
    float zoomFactor=9.5*(-cos(PI*iTime/18.)+1.);
    float maxIters=MAX_STEPS*(zoomFactor+18.)/36.;
    float zoom=pow(2.,zoomFactor);
    c/=zoom;
    float delt=((1./iResolution.y)/zoom)/AA;
    
    c*=matRot(zoomFactor/10.);
    c+=vec2(.159,.120);
    
    vec3 col;
    for(float y=0.;y<AA;y++){
    	for(float x=0.;x<AA;x++){
    		col+=samplePoint(c+vec2(x,y)*delt,maxIters);
    	}
    }
    col/=(AA*AA);
    gl_FragColor = vec4(col,1.0);
}